Rem TabUtilities.vbs
Rem An InDesign VBScript
Rem
Rem Adds a right tab stop at the right column edge, or a tab stop at the current
Rem cursor position, or sets the left indent at the current cursor position.
Rem Demonstrates getting page layout coordinates from text objects, setting tab stops,
Rem working with multi-column text frames.
Rem
Rem For more on InDesign/InCopy scripting see the documentation included in the Scripting SDK 
Rem available at http://www.adobe.com/devnet/indesign/sdk.html
Rem Or visit the InDesign scripting forum at http://www.adobeforums.com.
Rem
main
Function main()
	Set myInDesign = CreateObject("InDesign.Application.2021")
	Rem Set the user interaction level to allow the display of dialog boxes and alerts.
	myInDesign.ScriptPreferences.UserInteractionLevel = idUserInteractionLevels.idInteractWithAll
	If myInDesign.Documents.Count > 0 Then
	    If myInDesign.Selection.Count > 0 Then
	    Select Case TypeName(myInDesign.Selection.Item(1))
	        Case "InsertionPoint", "Character", "Word", "TextStyleRange", "Line", "Paragraph", "TextColumn", "Text", "TextFrame"
	                myDisplayDialog myInDesign
	        Case Else
	                MsgBox ("Please select some text (or a text frame) try again.")
	    End Select
	    Else
	        MsgBox ("Nothing is selected. Please select some text (or a text frame) try again.")
	    End If
	Else
	    MsgBox ("No documents are open. Please open a document and try again.")
	End If
End function
Rem Display a dialog box.
Function myDisplayDialog(myInDesign)
    Set myDialog = myInDesign.Dialogs.Add
    myDialog.Name = "TabUtilities"
    With myDialog.DialogColumns.Add
        With .BorderPanels.Add
            With .StaticTexts.Add
                .StaticLabel = "Set a Tab Stop At:"
            End With
            Set myTabButtons = .RadiobuttonGroups.Add
            With myTabButtons
                With .RadiobuttonControls.Add
                    .StaticLabel = "Right Column Edge"
                    .CheckedState = True
                End With
                With .RadiobuttonControls.Add
                    .StaticLabel = "Current Cursor Position"
                End With
                With .RadiobuttonControls.Add
                    .StaticLabel = "Left Indent"
                End With
                With .RadiobuttonControls.Add
                    .StaticLabel = "Hanging Indent at Cursor"
                End With
            End With
        End With
        With .BorderPanels.Add
            With .StaticTexts.Add
                .StaticLabel = "Tab Leader"
            End With
            With .DialogColumns.Add
                Set myTabLeaderField = .TextEditboxes.Add
                myTabLeaderField.EditContents = ""
            End With
        End With
    End With
    myResult = myDialog.Show
    If myResult = True Then
        myTabType = myTabButtons.SelectedButton
        myTabLeader = myTabLeaderField.EditContents
        myDialog.Destroy
        myAddTabStop myInDesign, myTabType, myTabLeader
    Else
       myDialog.Destroy
    End If
End Function
Rem Add the tab stop.
Function myAddTabStop(myInDesign, myTabType, myLeader)
    Select Case (myTabType)
        Case 0:
            Set myParagraphs = myInDesign.Selection.Item(1).Paragraphs
            For myCounter = 1 To myParagraphs.Count
                Set myParagraph = myParagraphs.Item(myCounter)
                myTabPosition = myParagraph.InsertionPoints.Item(1).ParentTextFrames.Item(1).TextFramePreferences.TextColumnFixedWidth
                myTabAlignment = idTabStopAlignment.idRightAlign
                Set myTabStop = myParagraph.TabStops.Add
                myTabStop.Alignment = myTabAlignment
                myTabStop.Leader = myLeader
                myTabStop.Position = myTabPosition
            Next
        Case 1:
            Rem Get the first insertion point in the selection.
            Set myInsertionPoint = myInDesign.Selection.Item(1).InsertionPoints.Item(1)
            Rem Work out which column it's in and get the left edge of that column.
            myTabPosition = myInsertionPoint.HorizontalOffset - myFindColumnEdge(myInsertionPoint)
            myTabAlignment = idTabStopAlignment.idLeftAlign
            Set myTabStop = myInsertionPoint.Paragraphs.Item(1).TabStops.Add
            myTabStop.Alignment = myTabAlignment
            myTabStop.Leader = myLeader
            myTabStop.Position = myTabPosition
        Case 2:
            Set myParagraphs = myInDesign.Selection.Item(1).Paragraphs
            For myCounter = 1 To myParagraphs.Count
                Set myParagraph = myParagraphs.Item(myCounter)
                myTabPosition = myParagraph.LeftIndent
                myTabAlignment = idTabStopAlignment.idLeftAlign
                Set myTabStop = myParagraph.TabStops.Add
                myTabStop.Alignment = myTabAlignment
                myTabStop.Leader = myLeader
                myTabStop.Position = myTabPosition
            Next
        Case 3:
            Set myParagraphs = myInDesign.Selection.Item(1).Paragraphs
            Rem Get the first insertion point in the selection.
            Set myInsertionPoint = myInDesign.Selection.Item(1).InsertionPoints.Item(1)
            Rem Work out which column it's in and get the left edge of that column.
            myTabPosition = myInsertionPoint.HorizontalOffset - myFindColumnEdge(myInsertionPoint)
            myTabAlignment = idTabStopAlignment.idLeftAlign
            For myCounter = 1 To myParagraphs.Count
                Set myParagraph = myParagraphs.Item(myCounter)
                myParagraph.LeftIndent = myTabPosition
                myParagraph.FirstLineIndent = -myTabPosition
                Set myTabStop = myParagraph.TabStops.Add
                myTabStop.Alignment = myTabAlignment
                myTabStop.Leader = myLeader
                myTabStop.Position = myTabPosition
            Next
    End Select
End Function
Rem This function returns the left edge of the text column containing the insertion point,
Rem in page coordinates. It could be modified to return the index of the column, as well.
Function myFindColumnEdge(myInsertionPoint)
    Dim myArray
    ReDim myArray(0)
    myPagePosition = myInsertionPoint.HorizontalOffset
    Set myTextFrame = myInsertionPoint.ParentTextFrames.Item(1)
    myColumnWidth = myTextFrame.TextFramePreferences.TextColumnFixedWidth
    myGutterWidth = myTextFrame.TextFramePreferences.TextColumnGutter
    myTextFrameWidth = myTextFrame.GeometricBounds(3) - myTextFrame.GeometricBounds(1)
    Rem Get the distance from the insertion point to the left edge of the text frame.
    myXOffset = myPagePosition - myTextFrame.GeometricBounds(1)
    For myCounter = 1 To myTextFrame.TextFramePreferences.TextColumnCount
        If myCounter = 1 Then
            Rem If the text frame is rectangular, the insetSpacing array will
            Rem have four values if it's not rectangular, insetSpacing will have one value.
            If UBound(myTextFrame.TextFramePreferences.InsetSpacing) = 4 Then
                myLeftInset = myTextFrame.TextFramePreferences.InsetSpacing(1)
                myRightInset = myTextFrame.TextFramePreferences.InsetSpacing(3)
            Else
                myLeftInset = myTextFrame.TextFramePreferences.InsetSpacing(0)
                myRightInset = myTextFrame.TextFramePreferences.InsetSpacing(0)
            End If
            myX1 = myTextFrame.GeometricBounds(1) + myLeftInset
            myX2 = myX1 + myColumnWidth
        Else
            If myCounter = myTextFrame.TextFramePreferences.TextColumnCount Then
                myX2 = myTextFrame.GeometricBounds(1) - myRightIndent
                myX1 = myX2 - myTextWidth
            Else
                myX1 = myTextFrame.GeometricBounds(1) + (myColumnWidth * myCounter) + (myGutterWidth * myCounter)
                myX2 = myX1 + myColumnWidth
            End If
        End If
        If IsEmpty(myArray(0)) Then
            myArray(0) = Array(myX1, myX2)
        Else
            ReDim Preserve myArray(UBound(myArray) + 1)
            myArray(UBound(myArray)) = Array(myX1, myX2)
        End If
    Next
    For myCounter = 0 To UBound(myArray)
        If (myPagePosition >= myArray(myCounter)(0)) And (myPagePosition <= myArray(myCounter)(1)) Then
            myColumnEdge = myArray(myCounter)(0)
        End If
    Next
    myFindColumnEdge = myColumnEdge
End Function

'' SIG '' Begin signature block
'' SIG '' MIIeUwYJKoZIhvcNAQcCoIIeRDCCHkACAQExDzANBglg
'' SIG '' hkgBZQMEAgEFADB3BgorBgEEAYI3AgEEoGkwZzAyBgor
'' SIG '' BgEEAYI3AgEeMCQCAQEEEE7wKRaZJ7VNj+Ws4Q8X66sC
'' SIG '' AQACAQACAQACAQACAQAwMTANBglghkgBZQMEAgEFAAQg
'' SIG '' CCROD/b7Toh3W9xAqM8CI9GePrt+PcJGYmLcWgYIpT2g
'' SIG '' ggyUMIIF0DCCBLigAwIBAgIQB3XcWt35KITbGdVVTAfs
'' SIG '' STANBgkqhkiG9w0BAQsFADBsMQswCQYDVQQGEwJVUzEV
'' SIG '' MBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3
'' SIG '' d3cuZGlnaWNlcnQuY29tMSswKQYDVQQDEyJEaWdpQ2Vy
'' SIG '' dCBFViBDb2RlIFNpZ25pbmcgQ0EgKFNIQTIpMB4XDTE5
'' SIG '' MDEzMTAwMDAwMFoXDTIxMDIwMzEyMDAwMFowgeYxEzAR
'' SIG '' BgsrBgEEAYI3PAIBAxMCVVMxGTAXBgsrBgEEAYI3PAIB
'' SIG '' AhMIRGVsYXdhcmUxHTAbBgNVBA8MFFByaXZhdGUgT3Jn
'' SIG '' YW5pemF0aW9uMRAwDgYDVQQFEwcyNzQ4MTI5MQswCQYD
'' SIG '' VQQGEwJVUzELMAkGA1UECBMCY2ExETAPBgNVBAcTCFNh
'' SIG '' biBKb3NlMRMwEQYDVQQKEwpBZG9iZSBJbmMuMSwwKgYD
'' SIG '' VQQLEyNJbGx1c3RyYXRvciwgSW5EZXNpZ24sIEluQ29w
'' SIG '' eSwgTXVzZTETMBEGA1UEAxMKQWRvYmUgSW5jLjCCASIw
'' SIG '' DQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBAIiKXEE3
'' SIG '' 5FJAWPRPxAu4g1GRRZmzrPW3SZL40s8opqkFWksx2dBE
'' SIG '' yP6+N6visRXUyDy+I979oO9tEtHBeYKx1XHy4NOLPl3u
'' SIG '' Lr8rWv5E3hrNw+QRwJvsMJLzBTS44811Rym8ddkt8lpj
'' SIG '' dG1PmC2aZQ73miR88+46IaZDtuabo3corXvrG0wmLFZb
'' SIG '' SrB80HAigwQiwHgh33cI2pPIYA2VdmEv5V3iI+AuYybL
'' SIG '' BPJ32YPqdvcoR3Ml/oYFcFlUb1sliNdngwqEeUTKBWVu
'' SIG '' OTeuRo2gOioizpUxR3cce25eoH8wONWUozkjPwcUEY8I
'' SIG '' RCePRf21c4kjjLGFSmpwEVQVQJcCAwEAAaOCAfEwggHt
'' SIG '' MB8GA1UdIwQYMBaAFI/ofvBtMmoABSPHcJdqOpD/a+rU
'' SIG '' MB0GA1UdDgQWBBSVoz2+cIajBhNjiGb0VJBYxDX9vzAu
'' SIG '' BgNVHREEJzAloCMGCCsGAQUFBwgDoBcwFQwTVVMtREVM
'' SIG '' QVdBUkUtMjc0ODEyOTAOBgNVHQ8BAf8EBAMCB4AwEwYD
'' SIG '' VR0lBAwwCgYIKwYBBQUHAwMwewYDVR0fBHQwcjA3oDWg
'' SIG '' M4YxaHR0cDovL2NybDMuZGlnaWNlcnQuY29tL0VWQ29k
'' SIG '' ZVNpZ25pbmdTSEEyLWcxLmNybDA3oDWgM4YxaHR0cDov
'' SIG '' L2NybDQuZGlnaWNlcnQuY29tL0VWQ29kZVNpZ25pbmdT
'' SIG '' SEEyLWcxLmNybDBLBgNVHSAERDBCMDcGCWCGSAGG/WwD
'' SIG '' AjAqMCgGCCsGAQUFBwIBFhxodHRwczovL3d3dy5kaWdp
'' SIG '' Y2VydC5jb20vQ1BTMAcGBWeBDAEDMH4GCCsGAQUFBwEB
'' SIG '' BHIwcDAkBggrBgEFBQcwAYYYaHR0cDovL29jc3AuZGln
'' SIG '' aWNlcnQuY29tMEgGCCsGAQUFBzAChjxodHRwOi8vY2Fj
'' SIG '' ZXJ0cy5kaWdpY2VydC5jb20vRGlnaUNlcnRFVkNvZGVT
'' SIG '' aWduaW5nQ0EtU0hBMi5jcnQwDAYDVR0TAQH/BAIwADAN
'' SIG '' BgkqhkiG9w0BAQsFAAOCAQEADtCQA7go0Xu2UKN6dFPe
'' SIG '' YJbS/OXx3n3IP0K9CGPDozeGV62MvbCp+DuptFa44FYR
'' SIG '' ZuljRXMxCjsjJmkJLD9Hhuik+a23iSwfOAnWK6AY/VoD
'' SIG '' ZatWvGG6mZzMRs/s5Whztt8IRxLMrLbA+ulDkDKTlqqf
'' SIG '' BWN8xAM23VX2IMmPYFXMf1TgyT3rCr2oontG6eWT0VYa
'' SIG '' j8DrYJuWtoNQaHIxSg3lGWyvqi1RwJc7GjVwJObnRCTH
'' SIG '' Faqmfxwry/5jEDjPNNUyDiMWIr2xxCbe5pu759mb9Hjl
'' SIG '' rSakmU9AhIxEURqKA3wmnF9Sw+OnazRGp4bvfkCeWDtK
'' SIG '' LdN4JKj5eh21hDCCBrwwggWkoAMCAQICEAPxtOFfOoLx
'' SIG '' FJZ4s9fYR1wwDQYJKoZIhvcNAQELBQAwbDELMAkGA1UE
'' SIG '' BhMCVVMxFTATBgNVBAoTDERpZ2lDZXJ0IEluYzEZMBcG
'' SIG '' A1UECxMQd3d3LmRpZ2ljZXJ0LmNvbTErMCkGA1UEAxMi
'' SIG '' RGlnaUNlcnQgSGlnaCBBc3N1cmFuY2UgRVYgUm9vdCBD
'' SIG '' QTAeFw0xMjA0MTgxMjAwMDBaFw0yNzA0MTgxMjAwMDBa
'' SIG '' MGwxCzAJBgNVBAYTAlVTMRUwEwYDVQQKEwxEaWdpQ2Vy
'' SIG '' dCBJbmMxGTAXBgNVBAsTEHd3dy5kaWdpY2VydC5jb20x
'' SIG '' KzApBgNVBAMTIkRpZ2lDZXJ0IEVWIENvZGUgU2lnbmlu
'' SIG '' ZyBDQSAoU0hBMikwggEiMA0GCSqGSIb3DQEBAQUAA4IB
'' SIG '' DwAwggEKAoIBAQCnU/oPsrUT8WTPhID8roA10bbXx6Ms
'' SIG '' rBosrPGErDo1EjqSkbpX5MTJ8y+oSDy31m7clyK6UXlh
'' SIG '' r0MvDbebtEkxrkRYPqShlqeHTyN+w2xlJJBVPqHKI3zF
'' SIG '' QunEemJFm33eY3TLnmMl+ISamq1FT659H8gTy3WbyeHh
'' SIG '' ivgLDJj0yj7QRap6HqVYkzY0visuKzFYZrQyEJ+d8FKh
'' SIG '' 7+g+03byQFrc+mo9G0utdrCMXO42uoPqMKhM3vELKlhB
'' SIG '' iK4AiasD0RaCICJ2615UOBJi4dJwJNvtH3DSZAmALeK2
'' SIG '' nc4f8rsh82zb2LMZe4pQn+/sNgpcmrdK0wigOXn93b89
'' SIG '' OgklAgMBAAGjggNYMIIDVDASBgNVHRMBAf8ECDAGAQH/
'' SIG '' AgEAMA4GA1UdDwEB/wQEAwIBhjATBgNVHSUEDDAKBggr
'' SIG '' BgEFBQcDAzB/BggrBgEFBQcBAQRzMHEwJAYIKwYBBQUH
'' SIG '' MAGGGGh0dHA6Ly9vY3NwLmRpZ2ljZXJ0LmNvbTBJBggr
'' SIG '' BgEFBQcwAoY9aHR0cDovL2NhY2VydHMuZGlnaWNlcnQu
'' SIG '' Y29tL0RpZ2lDZXJ0SGlnaEFzc3VyYW5jZUVWUm9vdENB
'' SIG '' LmNydDCBjwYDVR0fBIGHMIGEMECgPqA8hjpodHRwOi8v
'' SIG '' Y3JsMy5kaWdpY2VydC5jb20vRGlnaUNlcnRIaWdoQXNz
'' SIG '' dXJhbmNlRVZSb290Q0EuY3JsMECgPqA8hjpodHRwOi8v
'' SIG '' Y3JsNC5kaWdpY2VydC5jb20vRGlnaUNlcnRIaWdoQXNz
'' SIG '' dXJhbmNlRVZSb290Q0EuY3JsMIIBxAYDVR0gBIIBuzCC
'' SIG '' AbcwggGzBglghkgBhv1sAwIwggGkMDoGCCsGAQUFBwIB
'' SIG '' Fi5odHRwOi8vd3d3LmRpZ2ljZXJ0LmNvbS9zc2wtY3Bz
'' SIG '' LXJlcG9zaXRvcnkuaHRtMIIBZAYIKwYBBQUHAgIwggFW
'' SIG '' HoIBUgBBAG4AeQAgAHUAcwBlACAAbwBmACAAdABoAGkA
'' SIG '' cwAgAEMAZQByAHQAaQBmAGkAYwBhAHQAZQAgAGMAbwBu
'' SIG '' AHMAdABpAHQAdQB0AGUAcwAgAGEAYwBjAGUAcAB0AGEA
'' SIG '' bgBjAGUAIABvAGYAIAB0AGgAZQAgAEQAaQBnAGkAQwBl
'' SIG '' AHIAdAAgAEMAUAAvAEMAUABTACAAYQBuAGQAIAB0AGgA
'' SIG '' ZQAgAFIAZQBsAHkAaQBuAGcAIABQAGEAcgB0AHkAIABB
'' SIG '' AGcAcgBlAGUAbQBlAG4AdAAgAHcAaABpAGMAaAAgAGwA
'' SIG '' aQBtAGkAdAAgAGwAaQBhAGIAaQBsAGkAdAB5ACAAYQBu
'' SIG '' AGQAIABhAHIAZQAgAGkAbgBjAG8AcgBwAG8AcgBhAHQA
'' SIG '' ZQBkACAAaABlAHIAZQBpAG4AIABiAHkAIAByAGUAZgBl
'' SIG '' AHIAZQBuAGMAZQAuMB0GA1UdDgQWBBSP6H7wbTJqAAUj
'' SIG '' x3CXajqQ/2vq1DAfBgNVHSMEGDAWgBSxPsNpA/i/RwHU
'' SIG '' mCYaCALvY2QrwzANBgkqhkiG9w0BAQsFAAOCAQEAGTNK
'' SIG '' DIEzN9utNsnkyTq7tRsueqLi9ENCF56/TqFN4bHb6YHd
'' SIG '' nwHy5IjV6f4J/SHB7F2A0vDWwUPC/ncr2/nXkTPObNWy
'' SIG '' GTvmLtbJk0+IQI7N4fV+8Q/GWVZy6OtqQb0c1UbVfEnK
'' SIG '' ZjgVwb/gkXB3h9zJjTHJDCmiM+2N4ofNiY0/G//V4BqX
'' SIG '' i3zabfuoxrI6Zmt7AbPN2KY07BIBq5VYpcRTV6hg5ucC
'' SIG '' EqC5I2SiTbt8gSVkIb7P7kIYQ5e7pTcGr03/JqVNYUvs
'' SIG '' RkG4Zc64eZ4IlguBjIo7j8eZjKMqbphtXmHGlreKuWEt
'' SIG '' k7jrDgRD1/X+pvBi1JlqpcHB8GSUgDGCERcwghETAgEB
'' SIG '' MIGAMGwxCzAJBgNVBAYTAlVTMRUwEwYDVQQKEwxEaWdp
'' SIG '' Q2VydCBJbmMxGTAXBgNVBAsTEHd3dy5kaWdpY2VydC5j
'' SIG '' b20xKzApBgNVBAMTIkRpZ2lDZXJ0IEVWIENvZGUgU2ln
'' SIG '' bmluZyBDQSAoU0hBMikCEAd13Frd+SiE2xnVVUwH7Ekw
'' SIG '' DQYJYIZIAWUDBAIBBQCggZwwGQYJKoZIhvcNAQkDMQwG
'' SIG '' CisGAQQBgjcCAQQwHAYKKwYBBAGCNwIBCzEOMAwGCisG
'' SIG '' AQQBgjcCARUwLwYJKoZIhvcNAQkEMSIEIMxNVH8Etysu
'' SIG '' 3qnwaz/WF62RQ/0UpnY8Zj+EMLHfEWrtMDAGCisGAQQB
'' SIG '' gjcCAQwxIjAgoB6AHABBAGQAbwBiAGUAIABJAG4ARABl
'' SIG '' AHMAaQBnAG4wDQYJKoZIhvcNAQEBBQAEggEAYFLDtRug
'' SIG '' 51NAw7bwCj3Aw3umbgj/FW/pp+/HIysEp0mvV8BoYFPU
'' SIG '' 1HnRhBtAf5Hkv4TUzSBZIC5FWtmauOdF3FGWwjV7seUy
'' SIG '' I5VusLyGzJ815Inr5UEdFismyRaXDxSm9MVbycCU2wbF
'' SIG '' 8BcDd0LnXNDyGIg6w6AHSxk5dsD8z6w5Jcl8TpkEB4Ir
'' SIG '' yF95fJIgY2dcKNfLIA0QbF21biY1U/JL+zHluXd/1CMs
'' SIG '' wrdK9IMtx1xUhyAfsm7oP8El0qOk/VLqIeTSine1RCpN
'' SIG '' Chga7feFDDCSODGjiO2dhNP/JYt1Ci85iqUaRZeU6nmr
'' SIG '' 9KZiwdYKLuyXkBkQNO00AxXT86GCDsgwgg7EBgorBgEE
'' SIG '' AYI3AwMBMYIOtDCCDrAGCSqGSIb3DQEHAqCCDqEwgg6d
'' SIG '' AgEDMQ8wDQYJYIZIAWUDBAIBBQAwdwYLKoZIhvcNAQkQ
'' SIG '' AQSgaARmMGQCAQEGCWCGSAGG/WwHATAxMA0GCWCGSAFl
'' SIG '' AwQCAQUABCB/mzBJ1YvAhndDG7rFab8e+4i7XpTc9khR
'' SIG '' y7DIf4PPXwIQVulrIigqWsJ0cFre917O9BgPMjAyMDEw
'' SIG '' MDQwMDIxMzVaoIILuzCCBoIwggVqoAMCAQICEATNP4Vo
'' SIG '' rnbGG7D+cWDMp20wDQYJKoZIhvcNAQELBQAwcjELMAkG
'' SIG '' A1UEBhMCVVMxFTATBgNVBAoTDERpZ2lDZXJ0IEluYzEZ
'' SIG '' MBcGA1UECxMQd3d3LmRpZ2ljZXJ0LmNvbTExMC8GA1UE
'' SIG '' AxMoRGlnaUNlcnQgU0hBMiBBc3N1cmVkIElEIFRpbWVz
'' SIG '' dGFtcGluZyBDQTAeFw0xOTEwMDEwMDAwMDBaFw0zMDEw
'' SIG '' MTcwMDAwMDBaMEwxCzAJBgNVBAYTAlVTMRcwFQYDVQQK
'' SIG '' Ew5EaWdpQ2VydCwgSW5jLjEkMCIGA1UEAxMbVElNRVNU
'' SIG '' QU1QLVNIQTI1Ni0yMDE5LTEwLTE1MIIBIjANBgkqhkiG
'' SIG '' 9w0BAQEFAAOCAQ8AMIIBCgKCAQEA6WQ1nPqpmGVkG+QX
'' SIG '' 3LgpNsxnCViFTTDgyf/lOzwRKFCvBzHiXQkYwvaJjGkI
'' SIG '' BCPgdy2dFeW46KFqjv/UrtJ6Fu/4QbUdOXXBzy+nrEV+
'' SIG '' lG2sAwGZPGI+fnr9RZcxtPq32UI+p1Wb31pPWAKoMmki
'' SIG '' E76Lgi3GmKtrm7TJ8mURDHQNsvAIlnTE6LJIoqEUpfj6
'' SIG '' 4YlwRDuN7/uk9MO5vRQs6wwoJyWAqxBLFhJgC2kijE7N
'' SIG '' xtWyZVkh4HwsEo1wDo+KyuDT17M5d1DQQiwues6cZ3o4
'' SIG '' d1RA/0+VBCDU68jOhxQI/h2A3dDnK3jqvx9wxu5CFlM2
'' SIG '' RZtTGUlinXoCm5UUowIDAQABo4IDODCCAzQwDgYDVR0P
'' SIG '' AQH/BAQDAgeAMAwGA1UdEwEB/wQCMAAwFgYDVR0lAQH/
'' SIG '' BAwwCgYIKwYBBQUHAwgwggG/BgNVHSAEggG2MIIBsjCC
'' SIG '' AaEGCWCGSAGG/WwHATCCAZIwKAYIKwYBBQUHAgEWHGh0
'' SIG '' dHBzOi8vd3d3LmRpZ2ljZXJ0LmNvbS9DUFMwggFkBggr
'' SIG '' BgEFBQcCAjCCAVYeggFSAEEAbgB5ACAAdQBzAGUAIABv
'' SIG '' AGYAIAB0AGgAaQBzACAAQwBlAHIAdABpAGYAaQBjAGEA
'' SIG '' dABlACAAYwBvAG4AcwB0AGkAdAB1AHQAZQBzACAAYQBj
'' SIG '' AGMAZQBwAHQAYQBuAGMAZQAgAG8AZgAgAHQAaABlACAA
'' SIG '' RABpAGcAaQBDAGUAcgB0ACAAQwBQAC8AQwBQAFMAIABh
'' SIG '' AG4AZAAgAHQAaABlACAAUgBlAGwAeQBpAG4AZwAgAFAA
'' SIG '' YQByAHQAeQAgAEEAZwByAGUAZQBtAGUAbgB0ACAAdwBo
'' SIG '' AGkAYwBoACAAbABpAG0AaQB0ACAAbABpAGEAYgBpAGwA
'' SIG '' aQB0AHkAIABhAG4AZAAgAGEAcgBlACAAaQBuAGMAbwBy
'' SIG '' AHAAbwByAGEAdABlAGQAIABoAGUAcgBlAGkAbgAgAGIA
'' SIG '' eQAgAHIAZQBmAGUAcgBlAG4AYwBlAC4wCwYJYIZIAYb9
'' SIG '' bAMVMB8GA1UdIwQYMBaAFPS24SAd/imu0uRhpbKiJbLI
'' SIG '' FzVuMB0GA1UdDgQWBBRWUw/BxgenTdfYbldygFBM5Oye
'' SIG '' wTBxBgNVHR8EajBoMDKgMKAuhixodHRwOi8vY3JsMy5k
'' SIG '' aWdpY2VydC5jb20vc2hhMi1hc3N1cmVkLXRzLmNybDAy
'' SIG '' oDCgLoYsaHR0cDovL2NybDQuZGlnaWNlcnQuY29tL3No
'' SIG '' YTItYXNzdXJlZC10cy5jcmwwgYUGCCsGAQUFBwEBBHkw
'' SIG '' dzAkBggrBgEFBQcwAYYYaHR0cDovL29jc3AuZGlnaWNl
'' SIG '' cnQuY29tME8GCCsGAQUFBzAChkNodHRwOi8vY2FjZXJ0
'' SIG '' cy5kaWdpY2VydC5jb20vRGlnaUNlcnRTSEEyQXNzdXJl
'' SIG '' ZElEVGltZXN0YW1waW5nQ0EuY3J0MA0GCSqGSIb3DQEB
'' SIG '' CwUAA4IBAQAug6FEBUoE47kyUvrZgfAau/gJjSO5PdiS
'' SIG '' oeZGHEovbno8Y243F6Mav1gjskOclINOOQmwLOjH4eLM
'' SIG '' 7ct5a87eIwFH7ZVUgeCAexKxrwKGqTpzav74n8GN0SGM
'' SIG '' 5CmCw4oLYAACnR9HxJ+0CmhTf1oQpvgi5vhTkjFf2IKD
'' SIG '' LW0TQq6DwRBOpCT0R5zeDyJyd1x/T+k5mCtXkkTX726T
'' SIG '' 2UPHBDNjUTdWnkcEEcOjWFQh2OKOVtdJP1f8Cp8jXnv0
'' SIG '' lI3dnRq733oqptJFplUMj/ZMivKWz4lG3DGykZCjXzMw
'' SIG '' YFX1/GswrKHt5EdOM55naii1TcLtW5eC+MupCGxTCbT3
'' SIG '' MIIFMTCCBBmgAwIBAgIQCqEl1tYyG35B5AXaNpfCFTAN
'' SIG '' BgkqhkiG9w0BAQsFADBlMQswCQYDVQQGEwJVUzEVMBMG
'' SIG '' A1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3d3cu
'' SIG '' ZGlnaWNlcnQuY29tMSQwIgYDVQQDExtEaWdpQ2VydCBB
'' SIG '' c3N1cmVkIElEIFJvb3QgQ0EwHhcNMTYwMTA3MTIwMDAw
'' SIG '' WhcNMzEwMTA3MTIwMDAwWjByMQswCQYDVQQGEwJVUzEV
'' SIG '' MBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3
'' SIG '' d3cuZGlnaWNlcnQuY29tMTEwLwYDVQQDEyhEaWdpQ2Vy
'' SIG '' dCBTSEEyIEFzc3VyZWQgSUQgVGltZXN0YW1waW5nIENB
'' SIG '' MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA
'' SIG '' vdAy7kvNj3/dqbqCmcU5VChXtiNKxA4HRTNREH3Q+X1N
'' SIG '' aH7ntqD0jbOI5Je/YyGQmL8TvFfTw+F+CNZqFAA49y4e
'' SIG '' O+7MpvYyWf5fZT/gm+vjRkcGGlV+Cyd+wKL1oODeIj8O
'' SIG '' /36V+/OjuiI+GKwR5PCZA207hXwJ0+5dyJoLVOOoCXFr
'' SIG '' 4M8iEA91z3FyTgqt30A6XLdR4aF5FMZNJCMwXbzsPGBq
'' SIG '' rC8HzP3w6kfZiFBe/WZuVmEnKYmEUeaC50ZQ/ZQqLKfk
'' SIG '' dT66mA+Ef58xFNat1fJky3seBdCEGXIX8RcG7z3N1k3v
'' SIG '' BkL9olMqT4UdxB08r8/arBD13ays6Vb/kwIDAQABo4IB
'' SIG '' zjCCAcowHQYDVR0OBBYEFPS24SAd/imu0uRhpbKiJbLI
'' SIG '' FzVuMB8GA1UdIwQYMBaAFEXroq/0ksuCMS1Ri6enIZ3z
'' SIG '' bcgPMBIGA1UdEwEB/wQIMAYBAf8CAQAwDgYDVR0PAQH/
'' SIG '' BAQDAgGGMBMGA1UdJQQMMAoGCCsGAQUFBwMIMHkGCCsG
'' SIG '' AQUFBwEBBG0wazAkBggrBgEFBQcwAYYYaHR0cDovL29j
'' SIG '' c3AuZGlnaWNlcnQuY29tMEMGCCsGAQUFBzAChjdodHRw
'' SIG '' Oi8vY2FjZXJ0cy5kaWdpY2VydC5jb20vRGlnaUNlcnRB
'' SIG '' c3N1cmVkSURSb290Q0EuY3J0MIGBBgNVHR8EejB4MDqg
'' SIG '' OKA2hjRodHRwOi8vY3JsNC5kaWdpY2VydC5jb20vRGln
'' SIG '' aUNlcnRBc3N1cmVkSURSb290Q0EuY3JsMDqgOKA2hjRo
'' SIG '' dHRwOi8vY3JsMy5kaWdpY2VydC5jb20vRGlnaUNlcnRB
'' SIG '' c3N1cmVkSURSb290Q0EuY3JsMFAGA1UdIARJMEcwOAYK
'' SIG '' YIZIAYb9bAACBDAqMCgGCCsGAQUFBwIBFhxodHRwczov
'' SIG '' L3d3dy5kaWdpY2VydC5jb20vQ1BTMAsGCWCGSAGG/WwH
'' SIG '' ATANBgkqhkiG9w0BAQsFAAOCAQEAcZUS6VGHVmnN793a
'' SIG '' fKpjerN4zwY3QITvS4S/ys8DAv3Fp8MOIEIsr3fzKx8M
'' SIG '' IVoqtwU0HWqumfgnoma/Capg33akOpMP+LLR2HwZYuhe
'' SIG '' giUexLoceywh4tZbLBQ1QwRostt1AuByx5jWPGTlH0gQ
'' SIG '' GF+JOGFNYkYkh2OMkVIsrymJ5Xgf1gsUpYDXEkdws3XV
'' SIG '' k4WTfraSZ/tTYYmo9WuWwPRYaQ18yAGxuSh1t5ljhSKM
'' SIG '' Ycp5lH5Z/IwP42+1ASa2bKXuh1Eh5Fhgm7oMLSttosR+
'' SIG '' u8QlK0cCCHxJrhO24XxCQijGGFbPQTS2Zl22dHv1VjMi
'' SIG '' LyI2skuiSpXY9aaOUjGCAk0wggJJAgEBMIGGMHIxCzAJ
'' SIG '' BgNVBAYTAlVTMRUwEwYDVQQKEwxEaWdpQ2VydCBJbmMx
'' SIG '' GTAXBgNVBAsTEHd3dy5kaWdpY2VydC5jb20xMTAvBgNV
'' SIG '' BAMTKERpZ2lDZXJ0IFNIQTIgQXNzdXJlZCBJRCBUaW1l
'' SIG '' c3RhbXBpbmcgQ0ECEATNP4VornbGG7D+cWDMp20wDQYJ
'' SIG '' YIZIAWUDBAIBBQCggZgwGgYJKoZIhvcNAQkDMQ0GCyqG
'' SIG '' SIb3DQEJEAEEMBwGCSqGSIb3DQEJBTEPFw0yMDEwMDQw
'' SIG '' MDIxMzVaMCsGCyqGSIb3DQEJEAIMMRwwGjAYMBYEFAMl
'' SIG '' vVBe2pYwLcIvT6AeTCi+KDTFMC8GCSqGSIb3DQEJBDEi
'' SIG '' BCBYS30oZtJdhv8SSNH+ljupHWx4kyhwP5mFxpdgixze
'' SIG '' aDANBgkqhkiG9w0BAQEFAASCAQDnclImLq7hh3RkJozx
'' SIG '' 3X82XTQzpqME4vfXHSuQ+7wym/y+cG2aZIkjUvzovo72
'' SIG '' T5IzhpCP09M/jorWGliofmFuoWnhiHj+58fVFLYNfgqa
'' SIG '' C0OqCHbiogNJ4Sglg7M8pdxF7/6Q4oG38ZAmLHlOo5p/
'' SIG '' te2iV8ptFcz3+Hfj2L+/QoH0ENOOmzIj8K2D6t5bSS5q
'' SIG '' hyxBeDpsKfohlKpJD3fIDML0SwBAnwkqgt/InTHQkPwb
'' SIG '' 6qOqS02ksr1E/5Pv4m2WISHJDWQ9FALsERfkyqq2gFKE
'' SIG '' f5ja96QBTJz5mV4ThzL/GEp0EJflVUQci40mVnUTyIEw
'' SIG '' BOJpHjiceQDIHwoL
'' SIG '' End signature block
